<?php
/*


	 

			[base_category]
				|
	{Product} - category - groupe - [Customer]
*/
require_once(dirname(__FILE__) . '/../../classes/clariprintcategory.php');


class ClariprintCartModuleFrontController extends ModuleFrontController
{

	var $msgs = array();
	private static function createMultiLangField($field)
	{
		$languages = Language::getLanguages(false);
		$res = array();
		foreach ($languages AS $lang)
			$res[$lang['id_lang']] = $field;
		return $res;
	}


	public function displayAjaxAddToCart()
	{
		$this->msgs = array();

		$this->addToCart();
		$res = array('success' => true);
		if (count($this->msgs) > 0)
		{
			$res['messages'] = $this->msgs;
			$res['success'] = false;
		}
		if (Tools::isSubmit('reload'))
			header('Location: '.Tools::getValue('reload'));
		die(Tools::jsonEncode($res));
	}
	

	public function addToCart()
	{
		$id_customer = Context::getContext()->customer->id;
		if (!$id_customer) {
			$this->msgs[] = 'You must be connected to add custom products to you cart';
			return false;
		}
		
		
		$category = ClariprintCategory::getCategory($id_customer);

		$product =  new Product(Tools::getValue("clariprint_product_id"));


		if ($pref = Tools::getValue('clariprint_product_key'))
		{
			$res = ClariprintConnect::checkCache($pref);
			if (!$res->costs) $res = null;
		}

		if ($product  && $res)
		{
			$id_product_old = $product->id;
			unset($product->id);
			unset($product->id_product);
			$product->indexed = 0;
			$product->active = 	1;
			$product->quantity = 1;
			$object->out_of_stock = 0;

			$product->id_category_default = $category->id;
			
			
			$product->wholesale_price = $res->response;
			$product->price = $res->response;

			$name = Tools::getValue('clariprint_project_reference');
			if (!$name) $name = strftime("À la demande : %H:%M:%S");
			$product->name = $this->createMultiLangField($name);

			$product->description = $this->createMultiLangField($res->html);
			$product->description_short = $this->createMultiLangField(strftime("Produit sur mesure : %H:%M:%S"));

			$product->reference = $product->supplier_reference;

			/* AND Category::duplicateProductCategories($id_product_old, $product->id) */
			if (isset($res->weight)) {
				$product->weight = 0; // $res->weight;
			}

			if ($product->add()
				AND ($combinationImages = Product::duplicateAttributes($id_product_old, $product->id)) !== false
				AND GroupReduction::duplicateReduction($id_product_old, $product->id)
				AND Product::duplicateAccessories($id_product_old, $product->id)
				AND Product::duplicateFeatures($id_product_old, $product->id)
				AND Product::duplicateSpecificPrices($id_product_old, $product->id)
				AND Pack::duplicate($id_product_old, $product->id)
				AND Product::duplicateCustomizationFields($id_product_old, $product->id)
				AND Product::duplicateTags($id_product_old, $product->id)
				AND Product::duplicateDownload($id_product_old, $product->id))
			{
				$product->addToCategories($category->id);


				if ($product->hasAttributes())
					Product::updateDefaultAttribute($product->id);

				if (!Tools::getValue('noimage') AND !Image::duplicateProductImages($id_product_old, $product->id, $combinationImages))
					$this->_errors[] = Tools::displayError('An error occurred while copying images.');
				else
				{
					Hook::exec('actionProductAdd', array('product' => $product));
					Search::indexation(false, $product->id);
					$cart = self::$cart;
					if (!isset(self::$cart->id) OR !self::$cart->id)
					{
						self::$cart->add();
						if (self::$cart->id)
							self::$cookie->id_cart = (int)(self::$cart->id);
					}
					self::$cart->updateQty(1, $product->id);
				} 
				
				foreach(array('clariprint_upload_file_1','clariprint_upload_file_3','clariprint_upload_file_3') as $f) {
					if (isset($_FILES[$f]) && is_uploaded_file($_FILES[$f]['tmp_name'])) {
						do $uniqid = sha1(microtime());
						while (file_exists(_PS_DOWNLOAD_DIR_.$uniqid));

						if (!copy($_FILES[$f]['tmp_name'], _PS_DOWNLOAD_DIR_.$uniqid))
							$this->errors[] ='File copy failed';

						@unlink($_FILES[$f]['tmp_name']);

						if (empty($this->errors) && isset($uniqid))
						{
						
							$attachment = new Attachment();
							if ($an = $_FILES[$f]['name']) $attachment->name = self::createMultiLangField($an);
							else $attachment->name = self::createMultiLangField('PDF Source');
							$attachment->file = $uniqid;
							$attachment->mime = $_FILES[$f]['type'];
							$attachment->file_name = $_FILES[$f]['name'];
							if ($res = $attachment->add())
							{
								$attachment->attachProduct($product->id);
							}
						}
					}
				}
			}
			else
				$this->_errors[] = Tools::displayError('An error occurred while creating object.');
		}
	}
}