<?php


class ClariprintConnect {
	var $server_url;
	var $session;
	
	
	static public function getHttRequest($action,$datas=null,$timeout=1000) {
		if ($datas === null) $data = array();
		$request = new HttpRequest(Configuration::get('CL_SERVER_URL') . '/optimproject/json.wcl',HttpRequest::METH_POST);
//		$request->setMethod(HTTP_METH_POST);
		$request->setOptions(array(
			'timeout' => $timeout,
			'connecttimeout' => 200,
			'dns_cache_timeout' => 200));
		$request->setPostFields(array('login' => Configuration::get('CL_SERVER_LOGIN'),
								'password' => Configuration::get('CL_SERVER_PASSWORD'),
								'action' => $action,
								'datas' => $datas));

		try {
			$request->send();
			if ($x = $request->getResponseBody()) 
			{
				return json_decode($x);
			}
			
			return $request;
		} catch (HttpException $ex) {
			echo "HttpException $ex";
			return $ex;
		}
	}
	
	static public function checkAuth() {
		$r = self::getHttRequest('CheckAuth');
		if (is_object($r))
		{
			return $r->success;
		}
	}
	
	static public function quoteRequest($product)
	{
		
		if ($x = self::getHttRequest('QuoteRequest',$product,30000)) {
			if (isset($x->response)) {
				if ($v= $x->response)
				{
					$x->responseTxt = Tools::displayPrice($v, null) . 'HT'; 
				}
			}
			return $x;
		}
		return null;
	}
	static public function quoteRequestJson($json_product)
	{
		$x = self::getHttRequest('QuoteRequest',$json_product,30000);
		if ($v= $x->response)
		{
			$x->responseTxt = Tools::displayPrice($v, null) . 'HT'; 
		}
		return  $x;
	}
	static public function quoteRequesQuery($product)
	{
		$vals = array();
		parse_str($product,$vals);
		$p = json_encode($vals);
		$x = self::getHttRequest('QuoteRequest',$p,30000);
		if ($x)
		{
			if ($v = $x->response)
			{
				$x->responseTxt = Tools::displayPrice($v, null) . ' HT'; 
			}
		}
		return $x;
	}
	static function checkCache($product) {
		if ($v = Db::getInstance()->getValue('SELECT value FROM `'._DB_PREFIX_.'clariprint_solver_cache` WHERE  id_cache=\''. md5($product) .'\''))
			return json_decode($v);
		return null;
	}
	static function addToCache($product,$result) {
		$db = Db::getInstance();
		if (is_object($result)) $result = json_encode($result);
		if (is_array($result)) $result = json_encode($result);
			
		$db->execute(sprintf('INSERT INTO `'._DB_PREFIX_.'clariprint_solver_cache` (id_cache,created,value) VALUES (\'%s\',NOW(),\'%s\')',
										md5($product),$db->escape($result)));
		return $result;
	}
	
}
