<?php

/*
 * 2013 EXPERT SOLUTIONS
 *
 * ****************************************************
 * @category   Clariprint
 * @package	Clariprint
 * @author	Xavier Péchoultres
 * @site	http://www.clariprint.com
 * @copyright  Copyright (c) 2013 - 2013 EXPERT SOLUTIONS SALR
 * @license	proprietary
 */

class Clariprint_Config extends ObjectModel
{
	/** @var integer */
	public $id;
		
	/** @var integer */
	public $product_id;
	
	/** @var string */
	public $product_kind;

	/** @var string */
	public $dynamic;

	/** @var string */
	public $product_json;

	/** @var string */
//	public $product_xml;

	
	/**
	* @see ObjectModel::$definition
	*/
	public static $definition = array(
		'table' => 'clariprint_product',
		'primary' => 'id',
		'multilang' => FALSE,
		'fields' => array(
			'product_id' => array('type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => TRUE),
			'dynamic' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'required' => FALSE),
			'product_kind' => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
			'product_json' => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
			'date_add' => 	array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat'),
			'date_upd' => 				array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
			'date_cal' => 				array('type' => self::TYPE_DATE, 'validate' => 'isDate')
		),
	);
	
	static public function deleteForProductId($id_product='')
	{
		Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'clariprint_product`  WHERE sample.`product_id` = '.(int)$id_product);
	}

	public static function objectForProduct($id_product){
		$result = Db::getInstance()->getRow('SELECT id FROM `'._DB_PREFIX_.'clariprint_product` sample WHERE sample.`product_id` = '.(int)$id_product);
		if ($result) return new Clariprint_Config($result['id']);
		return null;
	}
	
	public static function loadByIdProduct($id_product){
		$result = Db::getInstance()->getRow('SELECT *
			FROM `'._DB_PREFIX_.'clariprint_product` sample
			WHERE sample.`product_id` = '.(int)$id_product
		);
		return new Clariprint_Config($result['id']);
	}

	public static function isDynamic($id_product) {
		return  Db::getInstance()->getValue(sprintf('SELECT dynamic FROM `%sclariprint_product` sample WHERE sample.`product_id` = %d', _DB_PREFIX_, $id_product));
	}

	
	public function product() {
		if ($this->product_json) return json_decode($this->product_json);
		return null;
	}
}

